/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.common.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.DolphinLookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowBoatGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import teamdraco.unnamedanimalmod.common.entity.util.ai.WhaleBreachGoal;
import teamdraco.unnamedanimalmod.init.UAMEntities;
import teamdraco.unnamedanimalmod.init.UAMItems;
import teamdraco.unnamedanimalmod.init.UAMSounds;

public class SouthernRightWhaleEntity
extends AnimalEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(SouthernRightWhaleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MOISTNESS_LEVEL = EntityDataManager.func_187226_a(SouthernRightWhaleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected boolean noBlow = false;

    public SouthernRightWhaleEntity(EntityType<? extends SouthernRightWhaleEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70749_g = new DolphinLookController((MobEntity)this, 10);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BreatheAirGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, (double)1.2f, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new WhaleBreachGoal(this, 10));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowBoatGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, GuardianEntity.class, 8.0f, 1.0, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 120.0).func_233815_a_(Attributes.field_233821_d_, (double)1.2f).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_233637_b_(Attributes.field_233823_f_)));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public int getMoistnessLevel() {
        return (Integer)this.field_70180_af.func_187225_a(MOISTNESS_LEVEL);
    }

    public void setMoisntessLevel(int p_211137_1_) {
        this.field_70180_af.func_187227_b(MOISTNESS_LEVEL, (Object)p_211137_1_);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_70050_g(this.func_205010_bg());
        this.field_70125_A = 0.0f;
        if (dataTag == null) {
            if ((double)this.field_70146_Z.nextFloat() > 0.1) {
                this.setVariant(this.field_70146_Z.nextInt(3));
            } else {
                this.setVariant(3);
            }
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(MOISTNESS_LEVEL, (Object)2400);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)((EntityType)UAMEntities.SOUTHERN_RIGHT_WHALE.get()).func_200721_a(this.field_70170_p);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
    }

    public boolean func_70648_aU() {
        return true;
    }

    public static boolean checkWhaleSpawnRules(EntityType<SouthernRightWhaleEntity> p_223364_0_, IWorld p_223364_1_, SpawnReason reason, BlockPos p_223364_3_, Random p_223364_4_) {
        return p_223364_1_.func_201674_k().nextFloat() > 0.99f && p_223364_1_.func_180495_p(p_223364_3_.func_177977_b()).func_203425_a(Blocks.field_150355_j);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_196087_aX;
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return size.field_220316_b * 0.4f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        BlockPos pos = this.func_233580_cy_().func_177984_a();
        if (!this.noBlow && this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a && this.field_70171_ac) {
            this.playBlowAnimation();
            this.noBlow = true;
        }
        if (this.field_70171_ac && this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a) {
            this.noBlow = false;
        }
        if (this.func_203008_ap()) {
            this.setMoisntessLevel(2400);
        } else {
            this.setMoisntessLevel(this.getMoistnessLevel() - 1);
            if (this.getMoistnessLevel() <= 0) {
                this.func_70097_a(DamageSource.field_205132_u, 1.0f);
            }
        }
    }

    protected void playBlowAnimation() {
        this.func_184185_a((SoundEvent)UAMSounds.SOUTHERN_RIGHT_WHALE_SONG.get(), 5.0f, 1.0f);
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)UAMSounds.SOUTHERN_RIGHT_WHALE_AMBIENT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)UAMSounds.SOUTHERN_RIGHT_WHALE_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)UAMSounds.SOUTHERN_RIGHT_WHALE_HURT.get();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)UAMItems.SOUTHERN_RIGHT_WHALE_SPAWN_EGG.get());
    }

    static class MoveHelperController
    extends MovementController {
        private final SouthernRightWhaleEntity whale;

        public MoveHelperController(SouthernRightWhaleEntity whaleIn) {
            super((MobEntity)whaleIn);
            this.whale = whaleIn;
        }

        public void func_75641_c() {
            if (this.whale.func_70090_H()) {
                this.whale.func_213317_d(this.whale.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.whale.func_70661_as().func_75500_f()) {
                double d2;
                double d1;
                double d0 = this.field_75646_b - this.whale.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = this.field_75647_c - this.whale.func_226278_cu_()) * d1 + (d2 = this.field_75644_d - this.whale.func_226281_cx_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                } else {
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.whale.field_70761_aq = this.whale.field_70177_z = this.func_75639_a(this.whale.field_70177_z, f, 10.0f);
                    this.whale.field_70759_as = this.whale.field_70177_z;
                    float f1 = (float)(this.field_75645_e * this.whale.func_233637_b_(Attributes.field_233821_d_));
                    if (this.whale.func_70090_H()) {
                        this.whale.func_70659_e(f1 * 0.02f);
                        float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                        f2 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f2), (float)-85.0f, (float)85.0f);
                        this.whale.field_70125_A = this.func_75639_a(this.whale.field_70125_A, f2, 5.0f);
                        float f3 = MathHelper.func_76134_b((float)(this.whale.field_70125_A * ((float)Math.PI / 180)));
                        float f4 = MathHelper.func_76126_a((float)(this.whale.field_70125_A * ((float)Math.PI / 180)));
                        this.whale.field_191988_bg = f3 * f1;
                        this.whale.field_70701_bs = -f4 * f1;
                    } else {
                        this.whale.func_70659_e(f1 * 0.1f);
                    }
                }
            } else {
                this.whale.func_70659_e(0.0f);
                this.whale.func_184646_p(0.0f);
                this.whale.func_70657_f(0.0f);
                this.whale.func_191989_p(0.0f);
            }
        }
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final SouthernRightWhaleEntity whale;

        public SwimGoal(SouthernRightWhaleEntity whale) {
            super((CreatureEntity)whale, 1.0, 2);
            this.whale = whale;
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }
    }
}

